#ifndef WEBSTATICDATA_h
#define WEBSTATICDATA_h

#include "../../ESPEasy_common.h"

#define PGMT( pgm_ptr ) ( reinterpret_cast< const __FlashStringHelper * >( pgm_ptr ) )

//-V::569

String generate_external_URL(const String& fname);

void serve_favicon();

enum class JSfiles_e {
  UpdateSensorValuesDevicePage,
  FetchAndParseLog,
  SaveRulesFile,
  GitHubClipboard,
  Reboot,
  Toasting,
  SplitPasteInput,
#if FEATURE_RULES_EASY_COLOR_CODE
  EasyColorCode_codemirror,
  EasyColorCode_espeasy,
  EasyColorCode_cm_plugins,
#endif
#ifdef USES_P113
  P113_script,
#endif // ifdef USES_P113
#ifdef USES_P165
  P165_digit,
#endif // ifdef USES_P165
};

enum class CSSfiles_e {
  ESPEasy_default,
#if FEATURE_RULES_EASY_COLOR_CODE
  EasyColorCode_codemirror,
#endif
};



void serve_CSS(CSSfiles_e cssfile);

void serve_JS(JSfiles_e JSfile);

#ifdef WEBSERVER_FAVICON
/*********************************************************************************************\
 * ESP Easy logo Favicon.ico 16x16 8 bit
\*********************************************************************************************/
// Generated using xxd:   xxd -i favicon.ico > favicon.ino
static const char favicon_8b_ico[] PROGMEM = {
  0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x10, 0x10, 0x00, 0x00, 0x01, 0x00,
  0x20, 0x00, 0x70, 0x01, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x89, 0x50,
  0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x49, 0x48,
  0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x08, 0x06,
  0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x01, 0x37, 0x49,
  0x44, 0x41, 0x54, 0x38, 0x8d, 0x9d, 0x93, 0xbd, 0x4e, 0xc3, 0x30, 0x14,
  0x85, 0x4f, 0x0a, 0x08, 0xc1, 0xd2, 0x64, 0xea, 0xab, 0xb0, 0x74, 0xe2,
  0x11, 0x32, 0x31, 0x31, 0x74, 0xaa, 0x3a, 0x97, 0x15, 0x77, 0x4c, 0x3a,
  0x87, 0x05, 0x31, 0x30, 0xb1, 0x98, 0x37, 0x70, 0xa5, 0x28, 0x5d, 0xc2,
  0xc0, 0xde, 0xbe, 0x40, 0x51, 0xc4, 0xe0, 0x86, 0x36, 0x55, 0x88, 0x91,
  0xcd, 0x10, 0xc5, 0x24, 0x10, 0xa5, 0x0d, 0x57, 0xf2, 0xf0, 0x59, 0x3a,
  0xf7, 0xe7, 0xe8, 0x5e, 0x38, 0x3e, 0xb7, 0x56, 0xb1, 0xa0, 0x49, 0x26,
  0x55, 0xf1, 0x8a, 0x68, 0xe2, 0x54, 0x48, 0xea, 0xf8, 0xdc, 0xc2, 0x2a,
  0x16, 0x54, 0xfd, 0x0a, 0x2f, 0x8c, 0x95, 0x17, 0xc6, 0x9a, 0xdd, 0x80,
  0xd7, 0x72, 0x2a, 0x24, 0xed, 0x74, 0xcf, 0x8e, 0x6c, 0x00, 0xd8, 0x09,
  0x05, 0x00, 0x98, 0xce, 0xd7, 0x18, 0xdd, 0xbf, 0xe1, 0x7d, 0x2b, 0x35,
  0xdf, 0x3c, 0x46, 0x9a, 0x27, 0xb3, 0x9c, 0x93, 0x4c, 0xe2, 0xf4, 0xd8,
  0xb0, 0x51, 0x6e, 0xd1, 0x0d, 0xb8, 0xc2, 0x60, 0xa1, 0x08, 0xe3, 0xb5,
  0x4c, 0x58, 0x95, 0x93, 0x4c, 0x2a, 0x9d, 0xa0, 0xad, 0x58, 0x27, 0x28,
  0x66, 0x6e, 0x23, 0x26, 0xec, 0xc7, 0x13, 0x9d, 0xa0, 0x8d, 0x18, 0x83,
  0x85, 0x72, 0x83, 0x9c, 0x1b, 0x3d, 0xd8, 0x27, 0x6e, 0xf4, 0x60, 0x9f,
  0xb8, 0xe2, 0xc1, 0x7f, 0x2a, 0xff, 0x31, 0xb1, 0x4d, 0xe5, 0x4a, 0x07,
  0x65, 0x0f, 0x0e, 0xa9, 0x4c, 0x18, 0x57, 0x84, 0x71, 0xbd, 0xd6, 0x3a,
  0xc1, 0x21, 0x95, 0x09, 0xe3, 0x0a, 0xc3, 0xa5, 0xc2, 0x70, 0xa9, 0xff,
  0x3b, 0xe7, 0x27, 0x06, 0xa6, 0xf3, 0x35, 0xc8, 0x53, 0x04, 0x72, 0xd5,
  0xc3, 0xed, 0xa5, 0x89, 0xc9, 0x2c, 0x67, 0xf7, 0xba, 0x87, 0x71, 0xdf,
  0xd4, 0x6b, 0x5e, 0x17, 0x46, 0x2a, 0x24, 0x7d, 0x78, 0xdd, 0xd8, 0x49,
  0x26, 0x31, 0xee, 0x9b, 0x00, 0x80, 0xbb, 0x97, 0x0f, 0x94, 0xb9, 0x88,
  0x9d, 0x50, 0xf0, 0xc2, 0x18, 0x00, 0x30, 0xba, 0xe8, 0x62, 0xfb, 0x29,
  0x9f, 0xe1, 0xf8, 0xdc, 0x4a, 0x85, 0xa4, 0xc5, 0x8c, 0x75, 0xe7, 0x5b,
  0x77, 0xea, 0xd1, 0xe6, 0x8b, 0x3a, 0x3e, 0xb7, 0xbe, 0x01, 0x4d, 0x0a,
  0x09, 0x35, 0x8e, 0xf2, 0xa6, 0xea, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static const unsigned int favicon_8b_ico_len = 390;

#endif


#ifdef WEBSERVER_GITHUB_COPY
static const char githublogo[] PROGMEM = {
  "<button class='button link' onclick='setGithubClipboard()' style='padding: 0px 2px; position: relative; top: 4px;'>"
  "<svg width='24' height='24' viewBox='-1 -1 26 26' style='position: relative; top: 2px;'>"
  "<path d='M12 .297c-6.63 0-12 5.373-12 12 0 5.303 3.438 9.8 8.205 11.385.6.113.82-.258.82-.577 0-.285-.01-1.04-.015-2.04-3.338.724-4.042-1.61-4.042-1.61C4.422 18.07 3.633 17.7 3.633 17.7c-1.087-.744.084-.729.084-.729 1.205.084 1.838 1.236 1.838 1.236 1.07 1.835 2.809 1.305 3.495.998.108-.776.417-1.305.76-1.605-2.665-.3-5.466-1.332-5.466-5.93 0-1.31.465-2.38 1.235-3.22-.135-.303-.54-1.523.105-3.176 0 0 1.005-.322 3.3 1.23.96-.267 1.98-.399 3-.405 1.02.006 2.04.138 3 .405 2.28-1.552 3.285-1.23 3.285-1.23.645 1.653.24 2.873.12 3.176.765.84 1.23 1.91 1.23 3.22 0 4.61-2.805 5.625-5.475 5.92.42.36.81 1.096.81 2.22 0 1.606-.015 2.896-.015 3.286 0 .315.21.69.825.57C20.565 22.092 24 17.592 24 12.297c0-6.627-5.373-12-12-12' stroke='white' fill='white'/></svg>"
  "</button>"
};

static const char DATA_GITHUB_CLIPBOARD_JS[] PROGMEM = {
  "function setGithubClipboard(){for(var e='ESP Easy | Information |\\n -----|-----|\\n',n=1;n<100;n++)"
  "{var o='copyText_'+n,t=document.getElementById(o);if(t){var a='|';n%2==0&&(a+='\\n'),e+=t.innerHTML.replace(/<[Bb][Rr]\\s*\\/?>/gim,'\\n')+a}else n=101}"
  "e=(e=e.replace(/<\\/[Dd][Ii][Vv]\\s*\\/?>/gim,'\\n')).replace(/<[^>]*>/gim,'');"
  "var i=document.createElement('textarea');i.style='position: absolute;left: -1000px; top: -1000px',i.innerHTML=e,document.body.appendChild(i),i.select(),document.execCommand('copy'),"
  "document.body.removeChild(i),alert('Copied: '+e+' to clipboard!');}"
};
#endif

#if defined(WEBSERVER_CSS) && !defined(WEBSERVER_EMBED_CUSTOM_CSS)
#ifdef EMBED_ESPEASY_DEFAULT_MIN_CSS
#ifndef EMBED_ESPEASY_DEFAULT_MIN_CSS_USE_GZ
// For the gzipped data, see below in the #else block
static const char DATA_ESPEASY_DEFAULT_MIN_CSS[] PROGMEM = {
".logviewer,tbody{overflow:auto}.container,.normal td{height:30px}.container,.container input:checked~.checkmark:after,.container2,.c"
"ontainer2 input:checked~.dotmark:after,.sub{display:block}:root{--bg1:#eee;--bg2:#cacaca;--bg3:#07d;--c1:#fff;--bdc1:silver;--bg4:#e"
"8e8e8;--bg5:#dbff0075;--c2:#444;--bg6:#fff;--bdc2:#444 #444 #fff;--c3:#000;--bg7:#bdbdbd;--bg8:#029b34;--c4:inherit;--c5:#07d;--bg10"
":#07d;--bg11:#f8f8f8;--c6:#fff;--ro:0deg;--iv:0}[data-theme=dark]{--bg1:#444;--bg2:#2e2e2e;--bg3:#00000085;--c1:#dfdfdf;--bdc1:#5454"
"54;--bg4:#2e2e2e;--bg5:#553044;--c2:#fff;--bg6:#222;--bdc2:transparent;--c3:#fff;--bg7:#00000030;--bg8:#30553d;--c4:#c3c3c3;--c5:#c3"
"c3c3;--bg10:#44607a;--bg11:#44607a;--c6:#c3c3c3;--ro:180deg;--iv:1}@media (prefers-color-scheme:dark){[data-theme=auto]{--bg1:#444;-"
"-bg2:#2e2e2e;--bg3:#00000085;--c1:#dfdfdf;--bdc1:#545454;--bg4:#2e2e2e;--bg5:#553044;--c2:#fff;--bg6:#222;--bdc2:transparent;--c3:#f"
"ff;--bg7:#00000030;--bg8:#30553d;--bg9:#222;--c4:#c3c3c3;--c5:#c3c3c3;--bg10:#44607a;--bg11:#44607a;--c6:#c3c3c3;--ro:180deg;--iv:1}"
"}* :not(font,a),.closebtn,.div_r,.wide,h1,h6,textarea{color:var(--c4)}.checkmark:after,.dotmark:after{content:'';display:none;positi"
"on:absolute}.button,.menu{text-decoration:none}.div_l,.menu{float:left}*{box-sizing:border-box;font-family:sans-serif;font-size:12pt"
";margin:0}h1{font-size:16pt;margin:8px 0}h3{background-color:var(--bg2);margin:-5px;padding:6px}h6{font-size:10pt}pre{font:1em monos"
"pace,monospace}.button{border:0;border-radius:5px;color:var(--c6);margin:5px;padding:5px 15px}.checkmark,input,select{background-col"
"or:var(--bg1)}#toastmessage,.button.help,.checkmark,.dotmark,.logviewer,hr,input,select,textarea{border:.1px solid gray}input[disabl"
"ed],input[disabled]:hover{background-color:var(--bg7)}.button.link.wide{display:inline-block;text-align:center}.button.link.red{back"
"ground-color:red}.button.help{border-radius:50%;font-family:monospace;padding:2px 7px}.checkmark,input,select,textarea{border-radius"
":5px}.button:hover{background:#369}input,select,textarea{margin:4px;padding:4px 8px}.wide{margin-bottom:5px;max-width:300px;min-widt"
"h:85px;width:95%}.sub,.widenumber{max-width:100px}textarea.wide{max-width:1000px}.xwide{width:300px}.container,.container2{cursor:po"
"inter;font-size:12pt;padding-left:35px}.container{margin-left:4px;margin-top:0;position:relative;user-select:none}.checkmark.disable"
"d{background-color:grey}.checkmark{height:25px;left:0;position:absolute;top:0;width:25px}.container .checkmark:after{border:solid #f"
"ff;border-width:0 3px 3px 0;height:10px;left:7px;top:3px;transform:rotate(45deg);width:5px}#toastmessage{background-color:var(--bg3)"
";border-radius:5px;bottom:30%;color:#fff;font-size:17px;left:282px;margin-left:-125px;min-width:250px;padding:16px;position:fixed;te"
"xt-align:center;visibility:hidden;z-index:1}.container2{margin-bottom:20px;margin-left:9px;position:relative;user-select:none}.dotma"
"rk{background-color:#eee;border-radius:50%;height:26px;left:0;position:absolute;top:0;width:26px}.container2 .dotmark:after{backgrou"
"nd:#fff;border-radius:50%;height:8px;left:8px;top:8px;width:8px}textarea{font-family:'Lucida Console',Monaco,monospace;max-height:60"
"vh;width:-webkit-fill-available;width:-moz-available}#toastmessage.show{animation:.5s fadein,.5s 2.5s fadeout;visibility:visible}.co"
"ntainer input,.container2 input{cursor:pointer;opacity:0;position:absolute}@keyframes fadein{from{bottom:20%;opacity:0}to{bottom:30%"
";opacity:.9}}@keyframes fadeout{from{bottom:30%;opacity:.9}to{bottom:0;opacity:0}}.level_0{color:#f1f1f1}.level_1{color:#fcff95}.lev"
"el_2{color:#9dcefe}.level_3{color:#a4fc79}.level_4{color:#f2ab39}.level_9{color:#f50}.logviewer{background-color:#272727;color:#f1f1"
"f1;height:60vh}.multirow th,.normal th{background-color:#444;border-color:var(--bdc1);color:var(--c1);padding:5px;width:100vw}.multi"
"row,.normal{border-spacing:0;width:100%}.multirow tr,.normal td,.normal tr{padding:5px}.multirow td{border-color:var(--bdc1);height:"
"30px;padding:4px;text-align:center}.tworow td,.tworow th{text-align:left}.sub{border-spacing:0}.even tr:nth-child(2n),.tworow tr:nth"
"-child(4n+3),.tworow tr:nth-child(4n+4),textarea{background-color:var(--bg4)}.menu.active,body{background-color:var(--bg6)}.apheader"
",.headermenu{padding:8px 12px;width:100vw}.note{color:#7b7b7b;font-style:italic}.headermenu{background-color:var(--bg11);border-bott"
"om:.1px solid #444;height:100px;position:fixed;top:0;z-index:1}.bodymenu{height:100vh;padding-top:100px}.menubar{position:inherit;to"
"p:54px;width:100%}a.menu{align-items:center;display:flex;height:46px;justify-content:center}.menu{color:var(--c2);border:1px solid t"
"ransparent;border-radius:5px 5px 0 0;padding:10px 10px 8px;white-space:nowrap}.menu.active{border-color:var(--bdc2);color:var(--c3);"
"border-width:.1px}.menu:hover{background:var(--bg7);color:var(--c3)}.menu_button{display:none}.on{color:#029b34}.off{color:red}.div_"
"r{background-color:var(--bg8);border-radius:4px;margin:2px;padding:1px 10px}.alert,.warning{color:#fff;margin-bottom:15px;padding:20"
"px}.highlight td{background-color:var(--bg5)}.div_br{clear:both}.alert{background-color:#f44336}.warning{background-color:#ffca17}.c"
"losebtn{cursor:pointer;font-size:22px;line-height:20px;margin-left:15px;transition:.3s}.closebtn:hover{color:#000}section{overflow-x"
":auto;padding:10px 0}footer{padding:0 5px;word-break:break-all}.closebtn,.div_r{float:right;color:var(--c6)}a,h1,h6{color:var(--c5)}"
".button,.container input:checked~.checkmark:not(.disabled),.container2 input:checked~.dotmark{background-color:var(--bg10)}canvas{fi"
"lter:invert(var(--iv)) hue-rotate(var(--ro))}@media screen and (max-width:780px){.showmenulabel{display:none}a.menu{width:12%}}@medi"
"a screen and (max-width:450px){.normal{min-width:300px}input.wide:focus{left:4px;position:absolute;z-index:1}}"
};
#else // ifndef EMBED_ESPEASY_DEFAULT_MIN_CSS_USE_GZ
// - upload the minified .js file to https://www.mischianti.org/online-converter-file-to-cpp-gzip-byte-array-3/
// - copy the Generated gzipped filearray
// - Modify the line "#define espeasy_default_min_css_gz_len <number>" 
//   to "static const int espeasy_default_min_css_gz_len = <number>;"
// - Modify the line "const uint8_t espeasy_default_min_css_gz[] ..."
//   to "static const char DATA_ESPEASY_DEFAULT_MIN_CSS_GZ[] ..."
// ------------------
//File: espeasy_default.min.css.gz, Size: 2017
static const int espeasy_default_min_css_gz_len = 2017;
static const char DATA_ESPEASY_DEFAULT_MIN_CSS_GZ[] PROGMEM = {  
0x1F, 0x8B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xD5, 0x18, 0xDB, 0x8E, 0xAB, 0x36, 
0xF0, 0x57, 0x90, 0x56, 0xAB, 0xB3, 0xB4, 0x01, 0x99, 0x5B, 0x2E, 0x44, 0x95, 0x2A, 0xF5, 0xB5, 
0xFD, 0x82, 0xAA, 0x3A, 0x32, 0x60, 0x82, 0xBB, 0x04, 0x47, 0xC6, 0xB9, 0x1D, 0xE4, 0x7E, 0x7B, 
0xC7, 0x06, 0x83, 0x21, 0xC9, 0xD1, 0x79, 0xE9, 0x43, 0x17, 0xED, 0xAE, 0x3D, 0x1E, 0xCF, 0x8C, 
0xE7, 0x6E, 0xFB, 0x35, 0x3B, 0x5C, 0x28, 0xB9, 0x12, 0xBE, 0x12, 0x19, 0x2B, 0xEE, 0x1D, 0xBB, 
0x10, 0x5E, 0xD6, 0xEC, 0x9A, 0xE2, 0xB3, 0x60, 0xD2, 0xCF, 0x59, 0x23, 0x30, 0x6D, 0x60, 0xD9, 
0x6F, 0x18, 0x3F, 0xE2, 0xDA, 0x11, 0x45, 0x57, 0x11, 0x7A, 0xA8, 0x44, 0x1A, 0xA1, 0xD3, 0x6D, 
0x86, 0x31, 0x0E, 0x1D, 0xDA, 0x9C, 0xCE, 0x22, 0xCD, 0x2B, 0x92, 0x7F, 0x92, 0xE2, 0x1F, 0x5F, 
0x0F, 0x8E, 0x98, 0x7F, 0xA6, 0xB8, 0x14, 0x33, 0xCC, 0xD0, 0x1E, 0x2F, 0xB7, 0x15, 0x4C, 0xD8, 
0x9B, 0xDA, 0x73, 0xD6, 0x15, 0xB4, 0x3D, 0xD5, 0xF8, 0x9E, 0x66, 0x35, 0xCB, 0x3F, 0x65, 0xCA, 
0x19, 0x13, 0x9D, 0xE7, 0x65, 0x87, 0x20, 0x7D, 0x23, 0x84, 0xEC, 0xD5, 0x30, 0x4C, 0xDF, 0x72, 
0xAC, 0x3E, 0x3D, 0x8B, 0xD2, 0x37, 0xB4, 0x29, 0x60, 0x98, 0x03, 0x4A, 0x59, 0x96, 0x0A, 0x58, 
0xC0, 0xB8, 0xA5, 0x35, 0x9C, 0x54, 0xA3, 0xC4, 0xB0, 0x77, 0xAB, 0x3E, 0x3D, 0x4B, 0xD2, 0xB7, 
0x22, 0x2B, 0x4B, 0x84, 0x36, 0x89, 0xDA, 0x05, 0xD4, 0xE2, 0x38, 0xD6, 0x2B, 0x6B, 0x8B, 0x40, 
0x0F, 0x76, 0xFA, 0x3F, 0x3D, 0x34, 0x57, 0xAC, 0x10, 0xD2, 0xA8, 0x9B, 0xF4, 0x2D, 0x2B, 0xD4, 
0xA7, 0x67, 0x5B, 0x58, 0x08, 0x77, 0x59, 0xA4, 0xC8, 0xE4, 0x71, 0x4A, 0x9B, 0x8A, 0x70, 0x2A, 
0xD4, 0x24, 0x31, 0xD2, 0xC1, 0x09, 0x90, 0x35, 0x56, 0xB2, 0x6E, 0xD5, 0xA7, 0x90, 0x46, 0xBE, 
0x9C, 0xA5, 0xA8, 0x20, 0x07, 0x18, 0xD1, 0x4B, 0x8A, 0xE4, 0x9F, 0x05, 0x16, 0xD8, 0x13, 0x15, 
0x39, 0x92, 0x5F, 0x0A, 0xD0, 0xD3, 0x5F, 0x46, 0x13, 0x46, 0x60, 0x10, 0x32, 0x24, 0xEA, 0x1B, 
0x35, 0xA1, 0x7F, 0xB6, 0xC9, 0xA0, 0x8E, 0xA2, 0x54, 0x9F, 0xD1, 0xC8, 0x5B, 0x12, 0xAB, 0xCF, 
0xA8, 0xC4, 0xDA, 0x09, 0x52, 0x26, 0x49, 0x84, 0x34, 0x55, 0x75, 0xF2, 0x41, 0x0B, 0x4A, 0x21, 
0x61, 0x18, 0x1A, 0x85, 0x08, 0x8E, 0x9B, 0xF6, 0x84, 0x39, 0x69, 0xC4, 0xA0, 0x0D, 0x83, 0xB7, 
0x31, 0x9C, 0x23, 0x64, 0xF4, 0x11, 0x21, 0xA0, 0x58, 0xF4, 0xFA, 0x78, 0xCB, 0x23, 0xF5, 0x0D, 
0xFA, 0x18, 0x27, 0xBD, 0x4A, 0xE2, 0x78, 0x8D, 0x36, 0x78, 0xD4, 0xCA, 0x38, 0x55, 0x5A, 0x19, 
0x51, 0x41, 0x31, 0xC1, 0x76, 0x52, 0x4D, 0x20, 0x7F, 0x3D, 0x92, 0x82, 0x62, 0xE7, 0xE3, 0xC4, 
0x49, 0x49, 0x78, 0xEB, 0xE5, 0xAC, 0x66, 0xDC, 0x6B, 0x73, 0xA5, 0xAB, 0x54, 0xE9, 0xCA, 0xED, 
0x6C, 0xED, 0x29, 0x5F, 0xFF, 0x5F, 0x6A, 0x2F, 0x3B, 0xEC, 0x0C, 0x95, 0xFF, 0x46, 0x91, 0xF2, 
0x27, 0x27, 0x6D, 0x98, 0xF8, 0x28, 0x21, 0x48, 0x57, 0xD8, 0x85, 0x68, 0xAD, 0x59, 0x4B, 0x32, 
0xD1, 0xAC, 0xFC, 0x82, 0x5E, 0xBE, 0x42, 0x54, 0x5E, 0x69, 0x41, 0x56, 0x55, 0xB0, 0xAA, 0xD6, 
0x2B, 0x41, 0x6E, 0x02, 0x4E, 0x80, 0x3B, 0xAD, 0xEE, 0xF4, 0x82, 0xF9, 0x87, 0x92, 0xCB, 0x95, 
0x8F, 0x09, 0x60, 0x16, 0xDA, 0x9D, 0x4A, 0x01, 0x70, 0xF0, 0xF4, 0xCB, 0x97, 0xBD, 0x09, 0xF0, 
0x86, 0x35, 0x64, 0x7F, 0x62, 0x2D, 0x15, 0x94, 0x35, 0x29, 0xCE, 0x5A, 0x56, 0x9F, 0x05, 0x91, 
0x7E, 0x76, 0x16, 0x82, 0x01, 0xF7, 0x23, 0x69, 0xCE, 0x9D, 0x62, 0xE8, 0x15, 0x24, 0x67, 0x1C, 
0x6B, 0x34, 0xB5, 0x49, 0x6A, 0xC1, 0xEA, 0x01, 0x03, 0x52, 0x19, 0x16, 0x69, 0x4D, 0x4A, 0x21, 
0x7F, 0xEA, 0x32, 0x76, 0xF3, 0x5A, 0xFA, 0x8D, 0x36, 0x87, 0x34, 0x63, 0xBC, 0x20, 0xDC, 0x03, 
0xC8, 0x5E, 0x1D, 0xCD, 0x2B, 0xF1, 0x91, 0xD6, 0xF7, 0xB4, 0x05, 0x23, 0x78, 0x2D, 0x44, 0x67, 
0xD9, 0x83, 0x01, 0x9B, 0xA4, 0x41, 0x78, 0x12, 0x7B, 0x90, 0xF6, 0x40, 0x1B, 0x88, 0xBA, 0x2A, 
0xE8, 0xAC, 0xA5, 0xF5, 0xB4, 0xB4, 0x3D, 0xDD, 0x1C, 0x58, 0x8E, 0xBA, 0x0C, 0xE7, 0x9F, 0x07, 
0xCE, 0xCE, 0x4D, 0xE1, 0xD9, 0x8A, 0x00, 0x8F, 0x72, 0x0D, 0xAE, 0x97, 0x9C, 0x6E, 0xFB, 0x13, 
0x2E, 0x0A, 0x25, 0xCB, 0x1A, 0xD2, 0x68, 0xB5, 0xB6, 0xA9, 0xA2, 0x93, 0x90, 0xE0, 0xBA, 0x1A, 
0x94, 0x06, 0xE4, 0xE8, 0x1C, 0x59, 0xC3, 0xC0, 0x3B, 0x72, 0xB2, 0x1A, 0x47, 0x46, 0x15, 0x5D, 
0x7F, 0x94, 0x14, 0xED, 0x87, 0x33, 0x71, 0x5C, 0xD0, 0x73, 0x9B, 0x2A, 0x0E, 0x33, 0x3B, 0xAC, 
0x47, 0xEE, 0x36, 0x73, 0x18, 0x3B, 0x41, 0xA2, 0x13, 0xB9, 0xB1, 0xD1, 0x4A, 0xA7, 0xE1, 0x55, 
0x4B, 0x6A, 0x92, 0x8B, 0xD7, 0xA7, 0x09, 0x5C, 0xF9, 0x26, 0x18, 0x6E, 0xC5, 0x91, 0xB4, 0x2D, 
0x3E, 0x90, 0xD5, 0x20, 0x90, 0x5F, 0x91, 0xFA, 0xB4, 0xB2, 0xC8, 0x19, 0x63, 0xAF, 0xFC, 0xA9, 
0xD8, 0x54, 0x7C, 0xC6, 0x65, 0x72, 0x9D, 0xE1, 0x34, 0x7E, 0x00, 0x72, 0x81, 0xCD, 0x69, 0xE1, 
0x1C, 0x38, 0xBE, 0x4B, 0x8D, 0xFC, 0x27, 0x38, 0x07, 0xCE, 0x6A, 0x52, 0xFC, 0xB5, 0x5A, 0xCC, 
0xD3, 0x4A, 0xD5, 0xAD, 0xD7, 0xB2, 0x6E, 0x5C, 0xA3, 0x2E, 0xBF, 0xA6, 0xCD, 0xA7, 0x76, 0xDA, 
0xB1, 0x96, 0xD0, 0x06, 0x60, 0xC4, 0xD3, 0x25, 0x65, 0xAF, 0x5D, 0x0A, 0xD7, 0xF4, 0xD0, 0xA4, 
0x39, 0xB8, 0x24, 0xE1, 0xF3, 0x8D, 0x9C, 0x14, 0x8F, 0x5C, 0x00, 0x28, 0xED, 0xC3, 0x77, 0x0B, 
0x4B, 0xA0, 0xF7, 0x99, 0x93, 0x8D, 0x26, 0x1C, 0x8D, 0x10, 0xC2, 0x61, 0x37, 0xAF, 0x6D, 0xB0, 
0xD4, 0x8E, 0x65, 0x62, 0xC3, 0xF7, 0x41, 0x01, 0x90, 0x24, 0xD6, 0x3B, 0xF9, 0x9C, 0xCA, 0xE0, 
0x06, 0xB1, 0xE5, 0x06, 0x30, 0x76, 0xB6, 0x8A, 0x9C, 0xD6, 0x4C, 0x8F, 0x00, 0xD1, 0x01, 0xA4, 
0x8F, 0xDA, 0x5D, 0x8E, 0xF8, 0xE6, 0xC1, 0x92, 0xA8, 0xA0, 0xEA, 0x23, 0x35, 0x87, 0xE5, 0x7E, 
0xBE, 0x55, 0xCB, 0xFD, 0x70, 0x97, 0xBC, 0x4B, 0x55, 0xA5, 0xFB, 0xA4, 0xD0, 0x9C, 0x8F, 0x19, 
0x88, 0x34, 0xED, 0x0C, 0xD4, 0x4E, 0x69, 0xA4, 0x30, 0x9C, 0xAC, 0x55, 0xDD, 0x4F, 0xDC, 0x34, 
0xDC, 0xE2, 0xF5, 0xBC, 0xC5, 0x08, 0xBB, 0xFC, 0xCC, 0x5B, 0x50, 0xFE, 0x89, 0x51, 0x65, 0xA6, 
0x65, 0xBC, 0x0E, 0x07, 0xF3, 0x54, 0xE8, 0xA7, 0x51, 0x32, 0x23, 0x63, 0xCE, 0xA7, 0xD7, 0x62, 
0x7D, 0x3A, 0x3D, 0x17, 0xEC, 0x04, 0x61, 0x34, 0x26, 0x1D, 0x4E, 0x6A, 0x48, 0x2B, 0x17, 0xB2, 
0x3F, 0x43, 0x46, 0xF0, 0x7A, 0x25, 0x0E, 0x29, 0x66, 0xB4, 0x93, 0x6F, 0x5C, 0xF0, 0xD1, 0x2B, 
0x0E, 0x9C, 0xDC, 0x2D, 0x4C, 0xD3, 0x35, 0x85, 0x4A, 0x5F, 0x9A, 0x33, 0x7A, 0xCC, 0x6F, 0xFB, 
0x5E, 0x84, 0xFE, 0xF4, 0xE1, 0x5C, 0x6A, 0x67, 0x99, 0x45, 0x4D, 0xAC, 0xF4, 0x61, 0xA2, 0xEB, 
0xC5, 0xE0, 0x1F, 0xFD, 0x7E, 0xE4, 0x44, 0x60, 0x55, 0xF5, 0x8B, 0xF6, 0x03, 0xF3, 0x00, 0x19, 
0xE6, 0xE0, 0x6E, 0x9A, 0x59, 0xA4, 0xFE, 0xAB, 0xDA, 0x53, 0x42, 0x7B, 0x07, 0xFD, 0x94, 0xC0, 
0x82, 0x7C, 0xC4, 0x09, 0x94, 0x00, 0x77, 0x10, 0x43, 0x49, 0x31, 0x0B, 0xF4, 0xD7, 0x61, 0x16, 
0xB9, 0x4F, 0x92, 0xD0, 0xE0, 0x45, 0x11, 0x44, 0x41, 0x8F, 0xAD, 0x25, 0xB5, 0xCC, 0xB5, 0x31, 
0x32, 0x85, 0xDB, 0x70, 0x32, 0x86, 0x86, 0x78, 0x81, 0x56, 0xD7, 0xE4, 0x6D, 0x61, 0x82, 0x2C, 
0xAF, 0x85, 0xF4, 0x7B, 0x9B, 0x94, 0x58, 0xD2, 0x1B, 0x29, 0x1E, 0x03, 0x78, 0x7F, 0xA1, 0x2D, 
0xCD, 0x68, 0x4D, 0xC5, 0x3D, 0xAD, 0x68, 0x01, 0x8E, 0xB9, 0xFF, 0xE6, 0xD1, 0xA6, 0x20, 0x37, 
0xA8, 0x6F, 0xB6, 0x43, 0xCD, 0xBD, 0x3E, 0x44, 0x0B, 0x59, 0x76, 0x36, 0xAF, 0xEF, 0xF8, 0xC6, 
0x90, 0xED, 0x1E, 0xB5, 0xA4, 0x3B, 0xD4, 0xC7, 0xD4, 0x60, 0xFC, 0x62, 0xFD, 0xC3, 0x7E, 0xB1, 
0x9E, 0xF9, 0x45, 0xE8, 0x2C, 0xAA, 0xA9, 0x9D, 0x04, 0x2C, 0xA7, 0x78, 0x64, 0xB9, 0x35, 0x1C, 
0xB7, 0x83, 0x33, 0x6C, 0xC7, 0x50, 0xDE, 0x5A, 0x91, 0xDA, 0xD9, 0xC9, 0xEB, 0xCB, 0xEF, 0xE7, 
0x9C, 0x16, 0xD8, 0xF9, 0x8D, 0x35, 0x20, 0x1A, 0xF9, 0xB2, 0xFA, 0x83, 0x35, 0x38, 0x67, 0x53, 
0x5D, 0xD2, 0xA9, 0x62, 0x60, 0xB0, 0x46, 0x97, 0x6A, 0x20, 0xE8, 0x5D, 0x49, 0xF6, 0x49, 0x81, 
0x0C, 0xAD, 0x6B, 0x0F, 0x5F, 0x30, 0xAD, 0x55, 0xD8, 0x98, 0xC5, 0x23, 0xFB, 0x36, 0x01, 0xE7, 
0xDE, 0xE6, 0xB7, 0x15, 0xBB, 0x76, 0xB8, 0xA1, 0xC7, 0xBE, 0xC6, 0xFB, 0x49, 0xEB, 0x94, 0xB8, 
0x20, 0x14, 0x9A, 0x00, 0x18, 0x86, 0x66, 0xCE, 0xCE, 0xC2, 0xB6, 0xB4, 0x1E, 0xD6, 0x44, 0x2E, 
0x2F, 0x25, 0x8F, 0xF7, 0x8D, 0x65, 0x22, 0x61, 0x70, 0x0A, 0x45, 0xE1, 0x89, 0x19, 0xE4, 0xAF, 
0x9F, 0xE4, 0x5E, 0x72, 0x0C, 0xA2, 0x0D, 0x32, 0x74, 0x25, 0x67, 0xC7, 0x6E, 0x74, 0x99, 0xF7, 
0x69, 0xB7, 0x14, 0xAC, 0xB3, 0x5C, 0xDF, 0xC0, 0xFD, 0x9D, 0x5C, 0x52, 0x01, 0xC9, 0x67, 0x64, 
0x16, 0xE8, 0x13, 0x1D, 0x64, 0x51, 0x97, 0x7E, 0x4D, 0x2E, 0xA4, 0xFE, 0x8A, 0x3A, 0x13, 0x54, 
0x81, 0xFA, 0x0C, 0x38, 0x18, 0xC1, 0x79, 0x59, 0xEE, 0x12, 0x03, 0x0E, 0x0D, 0x78, 0x57, 0xE4, 
0xD0, 0x19, 0x1B, 0x70, 0x64, 0xC0, 0x38, 0x2E, 0xF3, 0xCD, 0xCE, 0x80, 0xE3, 0x91, 0x48, 0x88, 
0xB3, 0x68, 0x04, 0xEF, 0x46, 0x70, 0x82, 0xE4, 0x54, 0xD3, 0x9F, 0x38, 0x7C, 0xB8, 0x51, 0xDF, 
0x7E, 0x26, 0xE1, 0xDE, 0xF2, 0x0D, 0xE9, 0x1F, 0xCF, 0xB5, 0xA0, 0x9C, 0x5D, 0x1D, 0x51, 0x4D, 
0x37, 0xCC, 0xEA, 0x09, 0x29, 0xD5, 0x95, 0x0F, 0x8E, 0x3C, 0xCB, 0x39, 0xD0, 0x7B, 0xBB, 0xF3, 
0x3E, 0x07, 0xE6, 0x56, 0x73, 0xB3, 0x1F, 0xAB, 0xCB, 0xE5, 0x3A, 0xB1, 0x33, 0xBC, 0x4C, 0x41, 
0x55, 0x9E, 0xAB, 0x36, 0xA0, 0x09, 0xFD, 0xDD, 0x16, 0xCE, 0xBE, 0xFE, 0x4E, 0x43, 0xDE, 0x59, 
0x8C, 0x6C, 0xF4, 0xA2, 0x7B, 0x29, 0xAA, 0x75, 0x77, 0xB6, 0x8B, 0xEF, 0xB3, 0xBE, 0x43, 0x5C, 
0x59, 0x4F, 0x6D, 0x35, 0x0E, 0xAB, 0xCE, 0xC2, 0xD3, 0x5D, 0xAD, 0xBE, 0x15, 0x2F, 0x4F, 0x21, 
0x7D, 0x30, 0x54, 0x03, 0x02, 0xA6, 0x8D, 0xA8, 0xBC, 0xBC, 0xA2, 0x75, 0xF1, 0x11, 0x36, 0xEE, 
0x44, 0xC7, 0x5E, 0x88, 0x9B, 0x9F, 0xA3, 0xD7, 0x4B, 0xB1, 0x6B, 0x75, 0x1F, 0xAF, 0xF2, 0xBE, 
0x6A, 0xF1, 0x55, 0xBB, 0xED, 0xE3, 0x5C, 0x25, 0xC5, 0x95, 0x7E, 0x49, 0x78, 0x89, 0xBD, 0x06, 
0x6C, 0x7C, 0xAA, 0x08, 0xB8, 0x3E, 0xE8, 0xB5, 0xFF, 0xAF, 0x9B, 0x75, 0xA3, 0x0F, 0xD5, 0x49, 
0x07, 0xE1, 0xD2, 0x76, 0x70, 0x0D, 0x21, 0xC6, 0xF3, 0x36, 0x99, 0xFA, 0x86, 0x22, 0x22, 0xEE, 
0x35, 0x49, 0xA9, 0x00, 0xA5, 0xE4, 0xD2, 0x26, 0xF7, 0xBA, 0x73, 0x0D, 0xC6, 0x3A, 0x35, 0x44, 
0x96, 0xD5, 0x6E, 0x6A, 0x4F, 0x1B, 0xCB, 0x25, 0x7A, 0x52, 0x60, 0x74, 0x2A, 0xB6, 0x4A, 0x88, 
0x3A, 0xAD, 0x66, 0x38, 0xED, 0x82, 0xB4, 0x67, 0x1A, 0x10, 0x85, 0xDE, 0x77, 0x3E, 0x5A, 0x45, 
0x19, 0x06, 0xAF, 0x31, 0x04, 0xCD, 0x4B, 0x80, 0xC2, 0x49, 0x62, 0xFB, 0xC0, 0xEF, 0x12, 0xF7, 
0x17, 0x18, 0x6D, 0x6A, 0x8F, 0x0A, 0x72, 0x6C, 0x4D, 0x3D, 0x33, 0x7D, 0x6B, 0x59, 0x93, 0x9B, 
0x91, 0x34, 0x56, 0xD5, 0xE3, 0xEF, 0x73, 0x2B, 0x68, 0x79, 0xF7, 0xCC, 0x75, 0xCA, 0x38, 0x92, 
0x26, 0x34, 0x8B, 0x91, 0xD0, 0x28, 0x20, 0x9D, 0x0E, 0x6E, 0xDF, 0x40, 0x1F, 0xAA, 0xB8, 0xA3, 
0x7E, 0x11, 0x34, 0x12, 0x63, 0xE9, 0x45, 0xCA, 0x48, 0xA8, 0x6F, 0x1B, 0xF7, 0xD7, 0x0A, 0x24, 
0xD4, 0xFE, 0x47, 0xA0, 0x0A, 0x5E, 0x39, 0x3E, 0xCD, 0x1C, 0xE2, 0x45, 0x38, 0x84, 0x8B, 0xC8, 
0x9D, 0xDA, 0x87, 0x5E, 0x0F, 0xCA, 0x2A, 0x3D, 0x9D, 0xC7, 0xF6, 0x76, 0xEA, 0xEC, 0x97, 0x34, 
0xFA, 0x1D, 0x5F, 0x87, 0xDB, 0x91, 0x7D, 0x9F, 0x94, 0x3E, 0x00, 0x06, 0x0F, 0xEA, 0x1F, 0x64, 
0x00, 0x52, 0x96, 0x9D, 0xD5, 0xC5, 0xEB, 0x4B, 0xED, 0x6B, 0xCF, 0xD9, 0x2E, 0x1B, 0x9C, 0xA9, 
0x7B, 0x54, 0x4D, 0xFC, 0xA4, 0x9D, 0x41, 0x39, 0xE0, 0xE8, 0x35, 0xE1, 0x50, 0x74, 0xAE, 0x98, 
0x37, 0xB0, 0xD0, 0x59, 0x1D, 0xD0, 0xBC, 0xDD, 0x08, 0xEC, 0x4B, 0x59, 0xA8, 0xB7, 0x56, 0x60, 
0xD9, 0x5A, 0x59, 0x57, 0x27, 0x94, 0x57, 0x22, 0x25, 0x6E, 0x2F, 0x75, 0x06, 0xD7, 0xE8, 0x9A, 
0x60, 0x0E, 0x57, 0x5B, 0x51, 0x0D, 0x7C, 0x9F, 0xE4, 0xD1, 0x32, 0x8E, 0xA3, 0x68, 0x2D, 0x47, 
0x81, 0x9E, 0x60, 0x94, 0x39, 0x0E, 0x36, 0x72, 0xBC, 0xE9, 0xBF, 0x6E, 0xB4, 0x43, 0x75, 0x64, 
0x7D, 0x77, 0x32, 0x3D, 0xCC, 0xB2, 0x67, 0xD2, 0xA7, 0xD2, 0x8E, 0xD5, 0x3B, 0xBC, 0x1F, 0xB5, 
0x13, 0xE1, 0xC1, 0xA8, 0xC6, 0x20, 0x08, 0xC9, 0x16, 0xBA, 0x28, 0x40, 0x1B, 0x1F, 0x21, 0xBD, 
0x9B, 0x7E, 0x86, 0x9C, 0x3B, 0x1D, 0x92, 0x25, 0x63, 0xAA, 0xCF, 0x31, 0x50, 0xE4, 0xE8, 0x3C, 
0x0F, 0x76, 0xF1, 0x32, 0x48, 0x53, 0x9F, 0xA9, 0xFE, 0x0B, 0x49, 0xB2, 0x96, 0xCB, 0xE7, 0x8A, 
0xE1, 0x3D, 0x80, 0x2B, 0x69, 0x97, 0xB7, 0x63, 0x89, 0xFB, 0x67, 0x8C, 0x79, 0xA4, 0x24, 0xEE, 
0xF4, 0xE6, 0xF0, 0x03, 0xEF, 0x9B, 0xEA, 0xAD, 0x64, 0xBC, 0x13, 0xB8, 0x3F, 0xF0, 0xB8, 0xF9, 
0x9D, 0x2C, 0x85, 0x5C, 0x99, 0xE3, 0xE6, 0x82, 0xDB, 0x0E, 0x9A, 0x26, 0x38, 0x30, 0xA4, 0x0B, 
0xD0, 0x8B, 0xF8, 0xE8, 0x11, 0xE8, 0xC5, 0x75, 0x9D, 0xEA, 0x4C, 0xBC, 0xA1, 0x67, 0xEF, 0xA1, 
0x9C, 0xB9, 0xAE, 0x79, 0xFD, 0x6A, 0x73, 0x4E, 0xA0, 0x0A, 0xE0, 0xA6, 0x70, 0x3E, 0xA6, 0x7B, 
0xD6, 0x66, 0x0B, 0x4A, 0x74, 0x3B, 0xDD, 0x56, 0xA9, 0x40, 0x81, 0x96, 0x8B, 0xD4, 0xF3, 0x30, 
0x19, 0x52, 0xCF, 0x90, 0x8C, 0xC2, 0x77, 0xF9, 0x7D, 0x8A, 0x71, 0xD2, 0x53, 0x1C, 0x4A, 0xEA, 
0xD4, 0xAC, 0xF7, 0xD7, 0x37, 0x7D, 0x6E, 0x7D, 0xDB, 0x4B, 0x4B, 0x96, 0x9F, 0xDB, 0x6E, 0xBC, 
0x76, 0x3D, 0xB6, 0xB9, 0x53, 0x56, 0x95, 0xFF, 0x02, 0x39, 0x7E, 0xE4, 0xC5, 0x9A, 0x16, 0x00, 
0x00
};
#endif // ifndef EMBED_ESPEASY_DEFAULT_MIN_CSS_USE_GZ
#endif // ifdef EMBED_ESPEASY_DEFAULT_MIN_CSS
#endif // WEBSERVER_CSS

// JavaScript blobs

#ifdef WEBSERVER_INCLUDE_JS
static const char DATA_REBOOT_JS[] PROGMEM = {
  "(i=document.getElementById('rbtmsg')).innerHTML='Please reboot: <input id='reboot' class='button link' value='Reboot' type='submit' onclick='r()'>';"
  "var x=new XMLHttpRequest;"
  "function d(){i.innerHTML='',clearTimeout(t)}"
  "function c(){i.innerHTML+='.',x.onload=d,x.open('GET',window.location.origin),x.send()}"
  "function b(){i.innerHTML='Rebooting..',t=setInterval(c,2e3)}"
  "function r(){i.innerHTML+=' (requesting)',x.onload=b,x.open('GET',window.location.origin+'/?cmd=reboot'),x.send()}"
};
#endif

static const char jsToastMessageBegin[] PROGMEM = {
  "function toasting() {"
    "var x=document.getElementById('toastmessage');"
    "x.innerHTML='"
};

static const char jsToastMessageEnd[] PROGMEM = {
  "';x.className='show';"
  "setTimeout(function(){x.innerHTML='';"
  // "x.className=x.className.replace('show','');"
  "x.className='';"
  " },2000);"
  "} "
};

static const char jsClipboardCopyPart1[] PROGMEM = {
  "<script>function setClipboard(){var cb='';"
  // " max_loop = 100;"
  "for(var i=1;i<100;i++){"
  "var cur_id='"
};

static const char jsClipboardCopyPart2[] PROGMEM = {
  "_'+i;"
  "var t=document.getElementById(cur_id);"
  // "if(t==null){i= max_loop + 1;"
  "if(t==null){i=101;"
  "}else{"
  "cb+=t.innerHTML.replace(/<[Bb][Rr]\\s*\\/?>/gim,'\\n')+'"
};

//Fix HTML
static const char jsClipboardCopyPart3[] PROGMEM = {
  "';}}"
  "cb=cb.replace(/<\\/[Dd][Ii][Vv]\\s*\\/?>/gim,'\\n');"
  "cb=cb.replace(/<[^>]*>/gim,'');"
  "var ti=document.createElement('textarea');"
  "ti.style='position:absolute;"
  "left:-1000px;top:-1000px';ti.innerHTML=cb;"
  "document.body.appendChild(ti);"
  "ti.select();"
  "document.execCommand('copy');"
  "document.body.removeChild(ti);"
  "alert('Copied: \"' + cb + '\" to clipboard!'); }"
  "</script>"
};

#ifdef WEBSERVER_INCLUDE_JS
// Manually minified js
// setTimeout needed or else the upload may fail right after fetching the existing rules file
static const char jsSaveRules[] PROGMEM = {
"function saveRulesFile(){'use strict';let e=document.getElementById('size'),t=document.getElementById('rules').value;t=t.replace(/\\r?\\n/g,'\\r\\n');let n=document.getElementById('set').value,l=new File([t],'rules'+n+'.txt',{type:'text/plain'}),o=new FormData;o.append('file',l),o.append('enctype','multipart/form-data');let a='/rules'+n+'.txt?callback='+Date.now();fetch(a).then((e=>e.text())).then((n=>{t===n?console.log('nothing to save...'):setTimeout((()=>fetch('/upload',{method:'POST',body:o,mode:'no-cors'}).then((e=>e.text())).then((n=>{setTimeout((()=>fetch(a).then((e=>e.text())).then((n=>{t===n?(toasting(),e.innerHTML=t.length):console.log('error when saving...')}))),200)}))),100)}))}"
};
#endif

// Script to split the pasted input over all fields with given class
// e.g.: split('$', ".query-input")
// This will replace the newlines, tabs and spaces with '$' 
// and splits it over the fields with class 'query-input'
static const char jsSplitMultipleFields[] PROGMEM = {
  "function split(t,i){var n=$(i);n.each(function(i){$(this).on('paste',function(){if(document.getElementById('splitpaste').checked){var i=$(this);"
  "setTimeout(function(){var s=i.val().split(/\\r?\\n/).join(t).split(/\\s+/).join(t).split(/\\t/).join(t).split(t);n.each(function(t){$(this).val(s[t])})},1)}})})}split('$','.query-input');"
};

#ifdef WEBSERVER_INCLUDE_JS
static const char DATA_UPDATE_SENSOR_VALUES_DEVICE_PAGE_JS[] PROGMEM = {
  "function elId(e){return document.getElementById(e)}"
  "function loopDeLoop(e,s){var o,a,n=0;isNaN(s)&&(s=1),null==e&&(e=1e3),"
  "i=setInterval(function(){if(n>0){clearInterval(i);return}"
  "++s>1||fetch('/json?view=sensorupdate').then(function(s){var n;if(200!==s.status){console.log('Looks like there was a problem. Status Code: '+s.status);return}"
  "s.json().then(function(s){e=s.TTL;"
  #if (defined(FEATURE_TASKVALUE_UNIT_OF_MEASURE) && FEATURE_TASKVALUE_UNIT_OF_MEASURE) || (defined(FEATURE_STRING_VARIABLES) && FEATURE_STRING_VARIABLES)
  "var r=void 0===s.ShowUoM||s.ShowUoM&&'false'!==s.ShowUoM;"
  #endif // if (defined(FEATURE_TASKVALUE_UNIT_OF_MEASURE) && FEATURE_TASKVALUE_UNIT_OF_MEASURE) || (defined(FEATURE_STRING_VARIABLES) && FEATURE_STRING_VARIABLES)
  "for(o=0;o<s.Sensors.length;o++)if(s.Sensors[o].hasOwnProperty('TaskValues'))"
  "for(a=0;a<s.Sensors[o].TaskValues.length;a++)try{n=s.Sensors[o].TaskValues[a].Value}catch(l){n=l.name}"
  "finally{if('TypeError'!==n){var u=s.Sensors[o].TaskValues[a].Value,t=s.Sensors[o].TaskValues[a].NrDecimals;t<255&&(u=parseFloat(u).toFixed(t));"
  #if (defined(FEATURE_TASKVALUE_UNIT_OF_MEASURE) && FEATURE_TASKVALUE_UNIT_OF_MEASURE) || (defined(FEATURE_STRING_VARIABLES) && FEATURE_STRING_VARIABLES)
  "var $=s.Sensors[o].TaskValues[a].UoM,T=s.Sensors[o].TaskValues[a].Presentation;T?u=T:$&&r&&(u+=' '+$);"
  #endif // if (defined(FEATURE_TASKVALUE_UNIT_OF_MEASURE) && FEATURE_TASKVALUE_UNIT_OF_MEASURE) || (defined(FEATURE_STRING_VARIABLES) && FEATURE_STRING_VARIABLES)
  "var S='value_'+(s.Sensors[o].TaskNumber-1)+'_'+(s.Sensors[o].TaskValues[a].ValueNumber-1),"
  "k='valuename_'+(s.Sensors[o].TaskNumber-1)+'_'+(s.Sensors[o].TaskValues[a].ValueNumber-1),"
  "V=elId(S),f=elId(k);V&&(V.innerHTML=u),"
  "f&&(f.innerHTML=s.Sensors[o].TaskValues[a].Name+':')}}"
  "clearInterval(i),loopDeLoop(e,0)})}).catch(function(s){console.log(s.message),e=5e3,clearInterval(i),loopDeLoop(e,0)}),n=1},e)}"
  "loopDeLoop(1e3,0);"
};
#endif // WEBSERVER_INCLUDE_JS

#ifdef WEBSERVER_INCLUDE_JS
static const char DATA_FETCH_AND_PARSE_LOG_JS[] PROGMEM = {
  "function elId(e){return document.getElementById(e)}"
  "function getBrowser(){var e,o=navigator.userAgent,r=o.match(/(opera|chrome|safari|firefox|msie|trident(?=\\/))\\/?\\s*(\\d+)/i)||[];return/trident/i.test(r[1])?{name:'IE',version:(e=/\brv[ :]+(\\d+)/g.exec(o)||[])[1]||''}:'Chrome'===r[1]&&null!=(e=o.match(/\bOPR|Edge\\/(\\d+)/))?{name:'Opera',version:e[1]}:(r=r[2]?[r[1],r[2]]:[navigator.appName,navigator.appVersion,'-?'],null!=(e=o.match(/version\\/(\\d+)/i))&&r.splice(1,1,e[1]),{name:r[0],version:r[1]})}"
  "var browser=getBrowser(),currentBrowser=browser.name+browser.version;textToDisplay=(browser.name=browser.version<12)?'Error: '+currentBrowser+' is not supported! Please try a modern web browser.':'Fetching log entries...',elId('copyText_1').innerHTML=textToDisplay,loopDeLoop(1e3,0);var logLevel=['Unused','Error','Info','Debug','Debug More','Undefined','Undefined','Undefined','Undefined','Debug Dev'];"
  "function loopDeLoop(e,o){let r='copyText_1';isNaN(o)&&(o=1),null==e&&(e=1e3),scrolling_type=e<=500?'auto':'smooth';var n,t,i='',l=0,"
  "s=setInterval(function(){if(l>0){clearInterval(s);return}++o>1?l=1:fetch('/logjson').then(function(o){if(200!==o.status){console.log('Looks like there was a problem. Status Code: '+o.status);return}o.json()"
  ".then(function(o){var l;for(null==t&&(t=''),n=0;n<o.Log.nrEntries;++n)try{l=o.Log.Entries[n].timestamp}catch(a){l=a.name}finally{'TypeError'!==l&&(i=o.Log.Entries[n].timestamp,t+='<div class=level_'+o.Log.Entries[n].level+' id='+i+'><font color=\"gray\">'+o.Log.Entries[n].timestamp+':</font> '+o.Log.Entries[n].text+'</div>')}e=o.Log.TTL,''!==t&&('Fetching log entries...'==elId(r).innerHTML&&(elId(r).innerHTML=''),elId(r).innerHTML+=t),t='',!0==(autoscroll_on=elId('autoscroll').checked)&&''!==i&&elId(i).scrollIntoView({behavior:scrolling_type}),elId('current_loglevel').innerHTML='Logging: '+logLevel[o.Log.SettingsWebLogLevel]+' ('+o.Log.SettingsWebLogLevel+')',clearInterval(s),"
  "loopDeLoop(e,0)})}).catch(function(o){elId(r).innerHTML+='<div>>> '+o.message+' <<</div>',autoscroll_on=elId('autoscroll').checked,elId(r).scrollTop=elId(r).scrollHeight,e=5e3,clearInterval(s),"
  "loopDeLoop(e,0)}),l=1},e)}"
};
#endif // WEBSERVER_INCLUDE_JS

#if defined(WEBSERVER_INCLUDE_JS) && defined(USES_P113)
static const char p113_script[] PROGMEM = {
  "function p113_main(){"
  "function elId(e){return document.getElementById(e)}"
  "function getCel(){return vi.querySelectorAll('.cel')}"
  "function elVal(e){return elId(e).value}"
  "function cntr(e){if(elVal('roix')>10||elVal('roiy')>10)return;let sc=[];getCel().forEach((c)=>{const b=c.getBoundingClientRect();if(e.x>=b.left&&e.y>=b.top&&e.x-scx<=b.right&&e.y-scy<=b.bottom)sc.push(c)});if(sc.length===1){elId('optc').value=parseInt(sc[0].textContent);upDsp()}}"
  "const vi=elId('vi');const sl=elId('sL');let imd=0;let ims=0;let st={},se={};let sr={};let oC=199;let xr=16;let yr=16;let ptg=0;let scx=vi.offsetWidth-vi.clientWidth;let scy=vi.offsetHeight-vi.clientHeight;let lck=0;let sm={w:96,h:96,};"
  "function clr(){getCel().forEach((c)=>{c.classList.remove('sel');c.classList.remove('oc')})}"
  "vi.addEventListener('mousedown',(e)=>{if(e.altKey){cntr(e)}else{lck=elId('lck').checked;if(imd&&lck){lck=0;return}imd=1;if(!ims){se={x:null,y:null};clr();}st={x:e.x+window.scrollX-vi.offsetLeft,y:e.y+window.scrollY-vi.offsetTop}}});"
  "vi.addEventListener('mouseup',(e)=>{if(lck||!imd)return;imd=0;const vc=vi.getBoundingClientRect();se={x:e.x+window.scrollX-vi.offsetLeft,y:e.y+window.scrollY-vi.offsetTop};sl.style.top=`0px`;sl.style.left=`0px`;sl.style.bottom='unset';sl.style.right='unset';sl.style.visibility='hidden';if(Math.abs(se.x-st.x)<sm.w||Math.abs(se.y-st.y)<sm.h){upDsp();return}gSelCls();pntSel(xr,yr,oC)});vi.addEventListener('dblclick',(e)=>{lck=0;imd=0;cntr(e)});"
  "vi.addEventListener('mousemove',x=>{imd&&(se={x:x.x+window.scrollX,y:x.y+window.scrollY},sr={x1:Math.min(st.x,se.x),y1:Math.min(st.y,se.y),x2:Math.max(st.x,se.x)+scx,y2:Math.max(st.y,se.y)+scy},(slt=sl.style).top=`${scx+Math.min(sr.y1,sr.y2)}px`,slt.left=`${scy+Math.min(sr.x1,sr.x2)}px`,slt.bottom=`${vi.offsetHeight+vi.offsetTop-Math.max(sr.y1,sr.y2)}px`,slt.right=`${vi.offsetWidth+vi.offsetLeft-Math.max(sr.x1,sr.x2)}px`,slt.visibility='visible',ims||clr())});"
  "function gSelCls(){let t=[];return sl.style.visibility='visible',getCel().forEach(e=>{let l=e.getBoundingClientRect();wx=window.scrollX,wy=window.scrollY,sr.x1-wx<=l.left-vi.offsetLeft+16&&sr.y1-wy<=l.top-vi.offsetTop+16&&sr.x2-wx-scx+16>=l.right&&sr.y2-wy-scy+16>=l.bottom&&t.push(e)}),"
  " t.length>0&&([ly,lx]=oiToXy(t[0].textContent),[ry,rx]=oiToXy(t[t.length-1].textContent),nx=lx+Math.floor((rx-lx)/2+.5),oC=gSP(ny=ly+Math.floor((ry-ly)/2),nx),xr=1+rx-lx,yr=1+ry-ly,ptg=1,elId('roix').value=xr,elId('roiy').value=yr,elId('optc').value=oC,ptg=0),t}"
  "function oiToXy(oidx){x=0;y=0;o=parseInt(oidx);if(o<128){y+=8;o=127-o}else{o-=128}x=o>>3;y+=o&7;return[y,x]}"
  "function pntSel(roix,roiy,oCen){if(!ptg){lx=0;ly=0;rx=15;ry=15;oo=oCen;if(roix>10||roiy>10){oCen=199}[ocy,ocx]=oiToXy(oCen);hx=Math.floor(roix/2);hy=Math.floor(roiy/2);dx=roix%2!=0?0:1;dy=roiy%2!=0?0:1;"
  " if((roix<16)||(roiy<16)){lx=ocx-hx;rx=ocx+hx-dx;ly=ocy-hy+dy;ry=ocy+hy;if((rx+1)-(lx+1)<4){d=3-((rx+1)-(lx+1));if(rx<(15-d)){rx+=d}else{lx-=d;ocx-=d/2}}if(rx>15||lx<0){d=lx<0?lx:rx-15;rx-=d;lx-=d;ocx-=d}if((ry+1)-(ly+1)<4){d=3-((ry+1)-(ly+1));if(ry<((15-d))){ry+=d}else{ly-=d;ocy-=d/2}}if(ry>15||ly<0){d=ly<0?ly:ry-15;ry-=d;ly-=d;ocy-=d}}cs=vi.querySelectorAll('.cel');"
  " for(y=0;y<16;++y){for(x=0;x<16;++x){cc=cs[y*16+x].classList;if(x>=lx&&x<=rx&&y>=ly&&y<=ry)cc.add('sel');else cc.remove('sel');if(x==ocx&&y==ocy)cc.add('oc');else cc.remove('oc')}}oc=gSP(ocy,ocx);if(oc!=oo){ptg=1;elId('optc').value=oc;ptg=0}}}"
  "function upDsp(){xr=elVal('roix');yr=elVal('roiy');optc=elVal('optc');pntSel(xr,yr,optc)}"
  "p113_main.upDsp=upDsp;"
  "function gSP(y,x){o=((x&15)<<3)+(y&7);return(y>7)?127-o:128+o}"
  "document.addEventListener('resize',()=>{scx=vi.offsetWidth-vi.clientWidth;scy=vi.offsetHeight-vi.clientHeight})}"
};
#endif // if defined(WEBSERVER_INCLUDE_JS) && defined(USES_P113)

#if defined(WEBSERVER_INCLUDE_JS) && defined(USES_P165)
// Semi-manually minified js for readability
static const char DATA_P165_DIGIT_JS[] PROGMEM = {
  "function elId(e){return document.getElementById(e)}"
  "function elTR(e){return elId(e)?.getElementsByTagName('TR')}"
  "function sh_col(a,b,d){s=elTR(a);for(r of s)"
  " {c=r?.children[b];if(c?.tagName=='TD'){c.style.width=20;c.style.display=d?'inline-block':'none'}}}"
  "function sh_row(a,b,c){r=elTR(a)[b];if(r)r.style.display=c?'block':'none'}"
  "function set_td(a,b,d,e,f){c=elTR(a)[d].children[e];if(c?.tagName=='TD')c.innerHTML=b?f:'&nbsp;'}"
  "function chWdth(a,b,c,d,e){for(t=b;t<b+c;t++)for(i=1;i<=7;i++)sh_col('dgtbl'+t,i,i<=a)}"
  "function chHght(a,c,d,e,f){for(t=c;t<c+d;t++){b='dgtbl'+t;for(i=1;i<8;i++){sh_row(b,8-i,i<=a);sh_row(b,8+i,i<=a)}}}"
  "function chCrnr(a,c,d,e,f){if(f)z='<span style=\"color:'+f+';\">&#x2638;</span>';else z='&#x2638;';"
  " for(t=c;t<c+d;t++){b='dgtbl'+t;for(i=0;i<18;i+=8){set_td(b,a,i,0,z);set_td(b,a,i,8,z)}}}"
  "function chDecp(a,b,c,d,e){for(t=b;t<b+c;t++)set_td('dgtbl'+t,a>0,16,9,''+a)}"
  "function chAddn(a,b,c,d,e){set_td('dxtbl'+(b+c),a>0,8,0,''+a)}"
  "function dgts(a,b){z=0;for(q=0;q<a;q++){v=[];for(f of b){v.push(parseInt(elId(f+q*10).value))}"
  " c=elId('crnr'+q*10).checked;"
  " x=v[5]*(3*v[0]+4*v[1]+(c?6:0)+v[2])+v[3];z+=x+v[4];elId('totp'+q*10).value=x}"
  " elId('totpx').value=z}"
  "function cbDis(c,s){l='disabled';elId(c).disabled=s;c=elId('cs'+c);if(s)c.classList.add(l);else c.classList.remove(l)}"
  "function stSeg(e,g){s=e.value==2;['spltg','dend'].forEach((a)=>{cbDis(a+g,s)})}"
};
#endif // if defined(WEBSERVER_INCLUDE_JS) && defined(USES_P165)

#endif // WEBSTATICDATA_h
