#ifndef DATATYPES_WIFIDISCONNECTREASON_H
#define DATATYPES_WIFIDISCONNECTREASON_H

#ifdef ESP32
enum WiFiDisconnectReason
{
  WIFI_DISCONNECT_REASON_UNSPECIFIED              = 1,
  WIFI_DISCONNECT_REASON_AUTH_EXPIRE              = 2,
  WIFI_DISCONNECT_REASON_AUTH_LEAVE               = 3,
  WIFI_DISCONNECT_REASON_ASSOC_EXPIRE             = 4,
  WIFI_DISCONNECT_REASON_ASSOC_TOOMANY            = 5,
  WIFI_DISCONNECT_REASON_NOT_AUTHED               = 6,
  WIFI_DISCONNECT_REASON_NOT_ASSOCED              = 7,
  WIFI_DISCONNECT_REASON_ASSOC_LEAVE              = 8,
  WIFI_DISCONNECT_REASON_ASSOC_NOT_AUTHED         = 9,
  WIFI_DISCONNECT_REASON_DISASSOC_PWRCAP_BAD      = 10, /* 11h */
  WIFI_DISCONNECT_REASON_DISASSOC_SUPCHAN_BAD     = 11, /* 11h */
  WIFI_DISCONNECT_REASON_IE_INVALID               = 13, /* 11i */
  WIFI_DISCONNECT_REASON_MIC_FAILURE              = 14, /* 11i */
  WIFI_DISCONNECT_REASON_4WAY_HANDSHAKE_TIMEOUT   = 15, /* 11i */
  WIFI_DISCONNECT_REASON_GROUP_KEY_UPDATE_TIMEOUT = 16, /* 11i */
  WIFI_DISCONNECT_REASON_IE_IN_4WAY_DIFFERS       = 17, /* 11i */
  WIFI_DISCONNECT_REASON_GROUP_CIPHER_INVALID     = 18, /* 11i */
  WIFI_DISCONNECT_REASON_PAIRWISE_CIPHER_INVALID  = 19, /* 11i */
  WIFI_DISCONNECT_REASON_AKMP_INVALID             = 20, /* 11i */
  WIFI_DISCONNECT_REASON_UNSUPP_RSN_IE_VERSION    = 21, /* 11i */
  WIFI_DISCONNECT_REASON_INVALID_RSN_IE_CAP       = 22, /* 11i */
  WIFI_DISCONNECT_REASON_802_1X_AUTH_FAILED       = 23, /* 11i */
  WIFI_DISCONNECT_REASON_CIPHER_SUITE_REJECTED    = 24, /* 11i */

  WIFI_DISCONNECT_REASON_BEACON_TIMEOUT    = 200,
  WIFI_DISCONNECT_REASON_NO_AP_FOUND       = 201,
  WIFI_DISCONNECT_REASON_AUTH_FAIL         = 202,
  WIFI_DISCONNECT_REASON_ASSOC_FAIL        = 203,
  WIFI_DISCONNECT_REASON_HANDSHAKE_TIMEOUT = 204
};
#endif

#endif