#include "_Plugin_Helper.h"
#ifdef USES_P151

// #######################################################################################################
// ####################### Plugin 151 Honeywell Digital Output Pressure Sensors ##########################
// #######################################################################################################

/** Changelog:
 * 2025-01-12 tonhuisman: Add support for MQTT AutoDiscovery
 */

# define PLUGIN_151
# define PLUGIN_ID_151         151
# define PLUGIN_NAME_151       "Environment - I2C Honeywell Pressure"
# define PLUGIN_VALUENAME1_151 "Pressure"
# define PLUGIN_VALUENAME2_151 "Temperature"

# include "./src/PluginStructs/P151_data_struct.h"

boolean Plugin_151(uint8_t function, struct EventStruct *event, String& string)
{
  boolean success = false;

  switch (function)
  {
    case PLUGIN_DEVICE_ADD:
    {
      auto& dev = Device[++deviceCount];
      dev.Number         = PLUGIN_ID_151;
      dev.Type           = DEVICE_TYPE_I2C;
      dev.VType          = Sensor_VType::SENSOR_TYPE_DUAL;
      dev.FormulaOption  = true;
      dev.ValueCount     = 2;
      dev.SendDataOption = true;
      dev.TimerOption    = true;
      dev.TimerOptional  = true;
      dev.PluginStats    = true;
      break;
    }

    case PLUGIN_GET_DEVICENAME:
    {
      string = F(PLUGIN_NAME_151);
      break;
    }

    case PLUGIN_GET_DEVICEVALUENAMES:
    {
      strcpy_P(ExtraTaskSettings.TaskDeviceValueNames[0], PSTR(PLUGIN_VALUENAME1_151));
      strcpy_P(ExtraTaskSettings.TaskDeviceValueNames[1], PSTR(PLUGIN_VALUENAME2_151));
      break;
    }

    # if FEATURE_MQTT_DISCOVER
    case PLUGIN_GET_DISCOVERY_VTYPES:
    {
      event->Par1 = static_cast<int>(Sensor_VType::SENSOR_TYPE_BARO_ONLY);
      event->Par2 = static_cast<int>(Sensor_VType::SENSOR_TYPE_TEMP_ONLY);
      success     = true;
      break;
    }
    # endif // if FEATURE_MQTT_DISCOVER

    case PLUGIN_I2C_HAS_ADDRESS:
    case PLUGIN_WEBFORM_SHOW_I2C_PARAMS:
    {
      // 8 bit I2C address notation in datasheet,
      // default: 40 (28 hex).
      // Other available standard addresses are:
      // 56 (38 hex)
      // 72 (48 hex)
      // 88 (58 hex)
      // 104 (68 hex)
      // 120 (78 hex)
      // 136 (88 hex)
      // 152 (98 hex)
      const uint8_t i2cAddressValues[] = {
        0x28,
        0x38,
        0x48,
        0x58,
        0x68,
        0x78,
        0x88,
        0x98
      };
      constexpr size_t addrCount = NR_ELEMENTS(i2cAddressValues);

      if (function == PLUGIN_WEBFORM_SHOW_I2C_PARAMS) {
        addFormSelectorI2C(F("pi2c"), addrCount, i2cAddressValues, P151_I2C_ADDR);
      } else {
        success = intArrayContains(addrCount, i2cAddressValues, event->Par1);
      }
      break;
    }

    # if FEATURE_I2C_GET_ADDRESS
    case PLUGIN_I2C_GET_ADDRESS:
    {
      event->Par1 = P151_I2C_ADDR;
      success     = true;
      break;
    }
    # endif // if FEATURE_I2C_GET_ADDRESS

    case PLUGIN_SET_DEFAULTS:
    {
      P151_I2C_ADDR = 0x28;

      P151_OUTPUT_MAX   = 14745; // counts (90% of 214 counts or 0x3999)
      P151_OUTPUT_MIN   = 1638;  // counts (10% of 214 counts or 0x0666)
      P151_PRESSURE_MAX = 1;
      P151_PRESSURE_MIN = 0;
      break;
    }

    case PLUGIN_WEBFORM_LOAD:
    {
      addFormNumericBox(F("Sensor Output Min"), F("out_min"), P151_OUTPUT_MIN, 0, (1 << 14) - 1);
      addFormNumericBox(F("Sensor Output Max"), F("out_max"), P151_OUTPUT_MAX, 0, (1 << 14) - 1);
      addFormFloatNumberBox(F("Pressure Min"), F("p_min"),
                            P151_PRESSURE_MIN, P151_MIN_PRESSURE_VALUE, 0.0f, 3);
      addFormFloatNumberBox(F("Pressure Max"), F("p_max"),
                            P151_PRESSURE_MAX, 0.0f, P151_MAX_PRESSURE_VALUE, 3);
      success = true;
      break;
    }

    case PLUGIN_WEBFORM_SAVE:
    {
      P151_I2C_ADDR     = getFormItemInt(F("pi2c"));
      P151_OUTPUT_MIN   = getFormItemInt(F("out_min"));
      P151_OUTPUT_MAX   = getFormItemInt(F("out_max"));
      P151_PRESSURE_MIN = getFormItemFloat(F("p_min"));
      P151_PRESSURE_MAX = getFormItemFloat(F("p_max"));

      success = true;
      break;
    }

    case PLUGIN_INIT:
    {
      success = initPluginTaskData(event->TaskIndex, new (std::nothrow) P151_data_struct());
      break;
    }

    case PLUGIN_READ:
    {
      P151_data_struct *P151_data = static_cast<P151_data_struct *>(getPluginTaskData(event->TaskIndex));

      if (nullptr != P151_data) {
        success = P151_data->fetch_last_sample(event);
      }

      break;
    }

    case PLUGIN_ONCE_A_SECOND:
    {
      P151_data_struct *P151_data = static_cast<P151_data_struct *>(getPluginTaskData(event->TaskIndex));

      if (nullptr != P151_data) {
        success = P151_data->plugin_read(event);
      }

      break;
    }

      /*
          case PLUGIN_TEN_PER_SECOND:
          {
            P151_data_struct *P151_data = static_cast<P151_data_struct *>(getPluginTaskData(event->TaskIndex));

            if (nullptr != P151_data) {
              success = P151_data->plugin_ten_per_second(event);
            }

            break;
          }

          case PLUGIN_FIFTY_PER_SECOND:
          {
            P151_data_struct *P151_data = static_cast<P151_data_struct *>(getPluginTaskData(event->TaskIndex));

            if (nullptr != P151_data) {
              success = P151_data->plugin_fifty_per_second(event);
            }

            break;
          }
       */
  }
  return success;
}

#endif // ifdef USES_P151
