# SparkFun MAX1704x Fuel Gauge Arduino Library

The MAX17043/MAX17044 are ultra-compact, low-cost,
host-side fuel-gauge systems for lithium-ion (Li+) batteries
in handheld and portable equipment. The MAX17043
is configured to operate with a single lithium cell and the
MAX17044 is configured for a dual-cell 2S pack.

The MAX17048/MAX17049 ICs are tiny, micropower current
fuel gauges for lithium-ion (Li+) batteries in handheld
and portable equipment. The MAX17048 operates with
a single lithium cell and the MAX17049 with two lithium
cells in series.

This Arduino library provides support for all four devices.

## Thanks

Parts of this library were inspired by [Daniel Porrey's max1704x library](https://github.com/porrey/max1704x). Thank you Daniel.

## Repository Contents

- **/examples** - Example sketches for the library (.ino). Run these from the Arduino IDE.
- **/src** - Source files for the library (.cpp, .h).
- **keywords.txt** - Keywords from this library that will be highlighted in the Arduino IDE.
- **library.properties** - General library properties for the Arduino package manager.

## Products That Use This Library

- [SparkFun LiPo Fuel Gauge (TOL-10617)](https://www.sparkfun.com/products/10617)

## Documentation

- **[Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library)** - Basic information on how to install an Arduino library.

## License Information

Please see [LICENSE.md](./LICENSE.md) for the license information.
